/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.biome.v1;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;

public interface BiomeLoadingContext {
    public ResourceKey<Biome> getResourceKey();

    public Biome getBiome();

    public Holder<Biome> holder();

    default public boolean hasBuiltInFeature(ConfiguredFeature<?, ?> configuredFeature) {
        ResourceKey key = (ResourceKey)BuiltinRegistries.f_123861_.m_7854_(configuredFeature).orElseThrow();
        return this.hasFeature(key);
    }

    default public boolean hasBuiltInPlacedFeature(PlacedFeature placedFeature) {
        ResourceKey key = (ResourceKey)BuiltinRegistries.f_194653_.m_7854_((Object)placedFeature).orElseThrow();
        return this.hasPlacedFeature((ResourceKey<PlacedFeature>)key);
    }

    default public boolean hasFeature(ResourceKey<ConfiguredFeature<?, ?>> key) {
        List featureSteps = this.getBiome().m_47536_().m_47818_();
        for (HolderSet featureSuppliers : featureSteps) {
            for (Holder featureSupplier : featureSuppliers) {
                if (!((PlacedFeature)featureSupplier.m_203334_()).m_191781_().anyMatch(cf -> this.getFeatureKey((ConfiguredFeature<?, ?>)cf).orElse(null) == key)) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean hasPlacedFeature(ResourceKey<PlacedFeature> key) {
        List featureSteps = this.getBiome().m_47536_().m_47818_();
        for (HolderSet featureSuppliers : featureSteps) {
            for (Holder featureSupplier : featureSuppliers) {
                if (this.getPlacedFeatureKey((PlacedFeature)featureSupplier.m_203334_()).orElse(null) != key) continue;
                return true;
            }
        }
        return false;
    }

    public Optional<ResourceKey<ConfiguredFeature<?, ?>>> getFeatureKey(ConfiguredFeature<?, ?> var1);

    public Optional<ResourceKey<PlacedFeature>> getPlacedFeatureKey(PlacedFeature var1);

    default public boolean validForBuiltInStructure(Structure structureFeature) {
        ResourceKey key = (ResourceKey)BuiltinRegistries.f_235988_.m_7854_((Object)structureFeature).orElseThrow();
        return this.validForStructure((ResourceKey<Structure>)key);
    }

    public boolean validForStructure(ResourceKey<Structure> var1);

    public Optional<ResourceKey<Structure>> getStructureKey(Structure var1);

    public boolean canGenerateIn(ResourceKey<LevelStem> var1);

    public boolean is(TagKey<Biome> var1);

    default public boolean is(Biome biome) {
        return this.getBiome() == biome;
    }

    default public boolean is(Holder<Biome> holder) {
        return this.holder() == holder;
    }

    default public boolean is(ResourceKey<Biome> resourceKey) {
        return this.getResourceKey() == resourceKey;
    }
}

